function effective_power_intensity = EffectivePowerIntensity(illumination_intensity, incident_angle);
%EFFECTIVEPOWERINTENSITY Effective Power Intensity.
%
%       I_EFF = EFFECTIVEPOWERINTENSITY(SI, IA) computes the time profile
%       of the effective illumination intensity SI due to the illumination
%       incident angle IA. The unit of I_EFF is [W/m^2].
%
%       The powerIntensity(t) is a vector that represents the time profile
%       of the illumination intensity [W/m^2].
%
%       The incidentAngle(t) is a vector that represents the time profile
%       of the illumination incident angle (i.e the angle between the vector
%       normal to the surface and the line of illumination) [radians].
%

effective_power_intensity = illumination_intensity .* cos(incident_angle);