% Life Support
% returns power in W and mass in kg
% duration is in mission seconds

function [power_day, power_night, life_mass] = Life_Support(duration, crew_size, support_type)

% kilowatts for nightime activities, ISS model
iss_refrig = .205;
water_recovery = .99;
thermal = 3.02;
waste_treat = .61;
air_revit = 2.35;

iss_power_night = iss_refrig + water_recovery + thermal + waste_treat + air_revit;

% kilowatts for daytime activities, ISS model
crew_comp = .2;
lighting = .1;
rec_equip = .3;
clean_equip = .2;
personal_com = .11;
laundry = .31;

iss_power_day = iss_power_night + crew_comp + lighting + rec_equip + clean_equip + personal_com;

% kilowatts for nightime activities, ALS model
als_refrig = .205;
als_water_recovery = .68;
als_thermal = 3.02;
als_waste_treat = .17;
als_air_revit = 2.53;
als_biomass = 13;

als_power_night = als_refrig + als_water_recovery + als_thermal + als_waste_treat + als_air_revit + als_biomass;

% kilowatts for daytime activities, ALS model
als_food_prep = .5;

als_power_day = als_power_night + als_food_prep + crew_comp + lighting + rec_equip + clean_equip + personal_com + laundry;

if support_type == 'iss' 
    power_day = iss_power_day*1000;
    power_night = iss_power_night*1000;
else
   power_day = als_power_day*1000;
   power_night = als_power_night*1000;
end

% compute life support system mass, adjusted from 730 day mission
base_mass = 20000;
astronaut_mass = 74 * crew_size;
oxygen_mass = 1502 / 730 * crew_size * duration/3600/24;
water_mass = 296 / 730  * crew_size * duration/3600/24; % 90% of used water recycled
food_mass = 3.8 / 2.2 * crew_size * duration/3600/24;
life_mass = base_mass + astronaut_mass + oxygen_mass + water_mass + food_mass;

