clear;
close all;
[storage, generation, solar] = power_read_xls('power_design_vector.xls')

% eta:  efficiency
% d_0:  initial degradation 
% d_dot: degradation rate
% I_eff: effective power intensity
% P_profile: profile of power per unit area
% P_current: currently available power per unit area

solar_array.Device = 'Solar Array';
solar_array.Efficiency = 0.185;
solar_array.InherentDegradation = 0.77;
solar_array.InitialDegradation = 0.01;
solar_array.DegradationRate = 0.0275/365.25/24/3600;

% Initial Time [sec]
t_0 = 0;

% Final Time [sec]
%t_f = 365.25 * 24 * 3600;
%t_f = 5 * 24 * 3600;
t_f = 50000;
%t_f = 1000000000;
% Time Increment [sec]
%dt = 24 * 3600;
dt = 5;
%dt = 1000000;
t = t_0:dt:t_f;

% Power Intensity [W/m^2]
power_intensity = 1367*ones(1,length(t));

% Obital Period [sec]
op = 90 * 60;

% Incident Angle [rad]
incident_angle = mod(0:2*pi/op*dt:t(length(t))*2*pi/op,pi) - pi/2*ones(1,length(t));
for i = 1:length(incident_angle)
    if mod(i,1082) > 541
        incident_angle(i) = pi/2;
    end
end

effective_power_intensity = EffectivePowerIntensity(power_intensity, incident_angle);
available_power_per_area = SolarPowerPerArea(solar_array, effective_power_intensity, t);

plot(t, power_intensity, t, effective_power_intensity, t, available_power_per_area);
legend('Solar Radiation','Effective Radiation','Available Power Intensity');

rtg_power = RTGPower(generation(1),t);
rtg_power_final=min(rtg_power);

figure(2)
plot(t,rtg_power)
