clc

  mu_sun = 1.327e20; %[m^3/s^2], Sun gravity constant
  r_earth = 1.49598e11; %[m], Earth-Sun average distance
  r_mars = 2.28e11; %[m], Mars-Sun average distance

% mu_sun = 3.986e14; %[m^3/s^2], Sun gravity constant
% r_earth = 6570000; %[m], Earth-Sun average distance
% r_mars = 42200000; %[m], Mars-Sun average distance


a_min = (r_earth+r_mars)/2;
a_max = a_min*5;
a_step = (a_max-a_min)/100;
i = 1;


for a=[a_min:a_step:a_max]
  [deltaV1, deltaV2, T_flight, time, r_mag, nu_time] = transfer_direct(r_earth,r_mars,a,mu_sun);

  %fprintf('\ndV = %g  | time = %g\n', deltaV1+deltaV2,deltaT/60/60)
  dV1(i) = deltaV1;
  dV2(i) = deltaV2;
  dt(i) = T_flight;
  i=i+1;
end


figure(5)
subplot(2,1,1), ...
	plot([a_min:a_step:a_max]/1000, (dV1+dV2)/1000,'k',...
       [a_min:a_step:a_max]/1000, dV2/1000,'b',...
       [a_min:a_step:a_max]/1000, dV1/1000,'r')

title('Earth-to-Mars Direct Transfer')
xlabel('Transfer Orbit Semi-major Axis [km]')
ylabel('\Delta V [km/s]')
legend('total burn', 'final burn', 'initial burn',0)
grid on

%figure(6)
subplot(2,1,2), plot([a_min:a_step:a_max]/1000, dt/60/60/24)
% title('Earth-to-Mars Direct Transfer')
xlabel('Transfer Orbit Semi-major Axis [km]')
ylabel('Time of Flight [days]')
grid on

orient tall
