%## Propulsion mass

function [p_mass, propulsion_system_mass, m_wet, eng_name] = propulsion_module(dV,m_dry)

	%Load Engine Data
	engine_data = eng_read;

	tank_factor = 10/100; % 10 percent - SMAD)
	margin = 5/100; % 25% for a first order estimate - SMAD)
  
	for i = 1:size(engine_data,1)-1 %loop over all engines we want to look at
    T_actual_req = 1; %initialize
    T_actual = 0; %initialize
    m_dry_tmp = m_dry;

    T = engine_data{i+1,1};
    Isp = engine_data{i+1,2};
    life = engine_data{i+1,3};
    eng_mass = engine_data{i+1,4};
    eng_name{i,1} = [engine_data{i+1,5} ' (' engine_data{i+1,6} ')'];

    if (life/60/60/24 < 1) %day
      accel = dV/(life/4);  %[m/s^2], required engine acceleration
    else
      accel = dV/(24*60*60);  %[m/s^2], required engine acceleration
    end

    %#################################################################
    while (T_actual < T_actual_req) %thrusts are inconsistent, iterate

      T_req = m_dry_tmp*accel;  %[N], required engine thrust
      num_eng = ceil(T_req/T);  %number of engines required to create dV in alotted time.
      total_eng_mass = eng_mass*num_eng; %[kg], mass of engine group

      %# Propellant mass
	    p_mass(i,1) = Propellant_Mass(Isp, m_dry+total_eng_mass, dV, margin);

      %# Propellant + Tank + Engine + {margin}
	    propulsion_system_mass(i,1) = Propulsion_Syst(total_eng_mass, p_mass(i,1), tank_factor);

      %# Total Vehicle Mass
      m_wet(i,1) = propulsion_system_mass(i,1)+m_dry;  %[kg], complete vehicle mass


      T_actual_req = m_wet(i,1)*accel;  %[N], actual required engine thrust
      T_actual = num_eng*T;  %[N], actual engine thrust

%       fprintf('Thrust Error = %g\n', (T_actual_req-T_actual))

      if (T_actual < T_actual_req) %thrusts are inconsistent
        m_dry_tmp = m_wet(i,1);
      end

    end %WHILE #######################################################

end



%########################################################################
%########################################################################
%########################################################################

function p_mass = Propellant_Mass(Isp, dry_mass, deltav, margin)
  g = 9.80665;  %[m/s^2], earth gravity 
  p_mass = dry_mass * (exp(deltav/(Isp*g)) - 1) * (1 + margin);

function propulsion_system_mass = Propulsion_Syst(engine_mass, prop_mass, tank_factor)
  propulsion_system_mass = prop_mass * (1 + tank_factor) + engine_mass;
	%%assume line/pressure regulating equipment mass is negligible for
	%%a first order assumption
