clear;
close all;

% Time
year  = 2003;
month = 10;
day   = 15;
hour  = 18;
min   = 0;
sec   = 0;

GEOPACK_RECALC(year,datenum(year,month,day) - datenum(year,1,1) + 1,hour,min,sec);

[phi,r] = meshgrid((0:2:360)*pi/180,1:0.1:10);
theta = -71*ones(size(phi));

[rows,columns] = size(theta);
for i = 1:rows
    for j = 1:columns
        [B_r,B_theta,B_phi] = GEOPACK_IGRF_GEO(r(i,j),theta(i,j),phi(i,j));
        B(i,j) = sqrt(B_r^2 + B_theta^2 + B_phi^2);
    end
end

[x,y,z] = sph2cart(theta,pi/2 - phi,r);

mesh(x,z,B);
xlabel('x-axis [Earth Radius]');
ylabel('z-axis [Earth Radius]');
zlabel('Magnetic Field Intensity [nT]');

figure;
contour(x,z,B,1000);
xlabel('x-axis [Earth Radius]');
ylabel('z-axis [Earth Radius]');
colorbar;


