function [BR,BTHETA,BPHI] = GEOPACK_BCARSP (X,Y,Z,BX,BY,BZ)
% function [BR,BTHETA,BPHI] = GEOPACK_BCARSP (X,Y,Z,BX,BY,BZ)
%      SUBROUTINE BCARSP (X,Y,Z,BX,BY,BZ,BR,BTHETA,BPHI)
% C
% CALCULATES SPHERICAL FIELD COMPONENTS FROM THOSE IN CARTESIAN SYSTEM
% C
% C-----INPUT:   X,Y,Z  - CARTESIAN COMPONENTS OF THE POSITION VECTOR
% C              BX,BY,BZ - CARTESIAN COMPONENTS OF THE FIELD VECTOR
% C-----OUTPUT:  BR,BTHETA,BPHI - SPHERICAL COMPONENTS OF THE FIELD VECTOR
% C
% C  NOTE: AT THE POLES (THETA=0 OR THETA=PI) WE ASSUME PHI=0,
% C        AND HENCE BTHETA=BX, BPHI=BY
% C
% C   WRITTEN AND ADDED TO THIS PACKAGE:  APRIL 1, 2003,
% C   AUTHOR:   N. A. TSYGANENKO
% C
RHO2=X^2+Y^2;
R=sqrt(RHO2+Z^2);
RHO=sqrt(RHO2);

if (RHO ~= 0.),
    CPHI=X/RHO;
    SPHI=Y/RHO;
else
    CPHI=1.;
    SPHI=0.;
end

CT=Z/R;
ST=RHO/R;

BR=(X*BX+Y*BY+Z*BZ)/R;
BTHETA=(BX*CPHI+BY*SPHI)*CT-BZ*ST;
BPHI=BY*CPHI-BX*SPHI;

%       RETURN
%       END
% end of function BCARSP
% C
% c=====================================================================================
% C

