function [BX,BY,BZ] = GEOPACK_BSPCAR (THETA,PHI,BR,BTHETA,BPHI)
% function [BX,BY,BZ] = GEOPACK_BSPCAR (THETA,PHI,BR,BTHETA,BPHI)
%      SUBROUTINE BSPCAR (THETA,PHI,BR,BTHETA,BPHI,BX,BY,BZ)
% C
% C   CALCULATES CARTESIAN FIELD COMPONENTS FROM SPHERICAL ONES
% C-----INPUT:   THETA,PHI - SPHERICAL ANGLES OF THE POINT IN RADIANS
% C              BR,BTHETA,BPHI -  SPHERICAL COMPONENTS OF THE FIELD
% C-----OUTPUT:  BX,BY,BZ - CARTESIAN COMPONENTS OF THE FIELD
% C
% C   LAST MOFIFICATION:  APRIL 1, 2003 (ONLY SOME NOTATION CHANGES)
% C
% C   WRITTEN BY:  N. A. TSYGANENKO
% C
S=sin(THETA);
C=cos(THETA);
SF=sin(PHI);
CF=cos(PHI);
BE=BR*S+BTHETA*C;
BX=BE*CF-BPHI*SF;
BY=BE*SF+BPHI*CF;
BZ=BR*C-BTHETA*S;
%       RETURN
%       END
% end of function BSPCAR
% c
% C==============================================================================
% C

