function [BXGSM,BYGSM,BZGSM] = GEOPACK_DIP (XGSM,YGSM,ZGSM)
%function [BXGSM,BYGSM,BZGSM] = GEOPACK_DIP (XGSM,YGSM,ZGSM)
%       SUBROUTINE DIP (XGSM,YGSM,ZGSM,BXGSM,BYGSM,BZGSM)
% C
% C  CALCULATES GSM COMPONENTS OF A GEODIPOLE FIELD WITH THE DIPOLE MOMENT
% C  CORRESPONDING TO THE EPOCH, SPECIFIED BY CALLING SUBROUTINE RECALC (SHOULD BE
% C  INVOKED BEFORE THE FIRST USE OF THIS ONE AND IN CASE THE DATE/TIME WAS CHANGED).
% C
% C--INPUT PARAMETERS: XGSM,YGSM,ZGSM - GSM COORDINATES IN RE (1 RE = 6371.2 km)
% C
% C--OUTPUT PARAMETERS: BXGSM,BYGSM,BZGSM - FIELD COMPONENTS IN GSM SYSTEM, IN NANOTESLA.
% C
% C  LAST MODIFICATION: MARCH 31, 2003
% C
% C  AUTHOR: N. A. TSYGANENKO
% C

%      COMMON /GEOPACK1/ AAA(10),SPS,CPS,BBB(23)
%      COMMON /GEOPACK2/ G(66),H(66),REC(66)
global GEOPACK1
global GEOPACK2

DIPMOM=sqrt(GEOPACK2.G(2)^2+GEOPACK2.G(3)^2+GEOPACK2.H(3)^2);

P=XGSM^2;
U=ZGSM^2;
V=3.*ZGSM*XGSM;
T=YGSM^2;
Q=DIPMOM/sqrt(P+T+U)^5;
BXGSM=Q*((T+U-2.*P)*GEOPACK1.SPS-V*GEOPACK1.CPS);
BYGSM=-3.*YGSM*Q*(XGSM*GEOPACK1.SPS+ZGSM*GEOPACK1.CPS);
BZGSM=Q*((P+T-2.*U)*GEOPACK1.CPS-V*GEOPACK1.SPS);
%      RETURN
%      END
% end of function DIP
% C*******************************************************************
% c

