function [A,B,C] = GEOPACK_GEOMAG(X,Y,Z,J)
% function [A,B,C] = GEOPACK_GEOMAG(X,Y,Z,J)
%      SUBROUTINE GEOMAG (XGEO,YGEO,ZGEO,XMAG,YMAG,ZMAG,J)
% C
% C    CONVERTS GEOGRAPHIC (GEO) TO DIPOLE (MAG) COORDINATES OR VICA VERSA.
% C
% C                    J>0                       J<0
% C-----INPUT:  J,XGEO,YGEO,ZGEO           J,XMAG,YMAG,ZMAG
% C-----OUTPUT:    XMAG,YMAG,ZMAG           XGEO,YGEO,ZGEO
% C
% C
% C  ATTENTION:  SUBROUTINE  RECALC  MUST BE INVOKED BEFORE GEOMAG IN TWO CASES:
% C     /A/  BEFORE THE FIRST TRANSFORMATION OF COORDINATES
% C     /B/  IF THE VALUES OF IYEAR AND/OR IDAY HAVE BEEN CHANGED
% C
% C
% C   LAST MOFIFICATION:  MARCH 30, 2003 (INVOCATION OF RECALC INSIDE THIS S/R WAS REMOVED)
% C
% C   AUTHOR:  N. A. TSYGANENKO
% C

%      COMMON /GEOPACK1/ ST0,CT0,SL0,CL0,CTCL,STCL,CTSL,STSL,AB(19),BB(8)
if J<0,
    [A,B,C] = GEOPACK_MAG2GEO(X,Y,Z);
else
    [A,B,C] = GEOPACK_GEO2MAG(X,Y,Z);
end

function [XMAG,YMAG,ZMAG] = GEOPACK_GEO2MAG(XGEO,YGEO,ZGEO)
global GEOPACK1;
XMAG=XGEO*GEOPACK1.CTCL+YGEO*GEOPACK1.CTSL-ZGEO*GEOPACK1.ST0;
YMAG=YGEO*GEOPACK1.CL0-XGEO*GEOPACK1.SL0;
ZMAG=XGEO*GEOPACK1.STCL+YGEO*GEOPACK1.STSL+ZGEO*GEOPACK1.CT0;

function [XGEO,YGEO,ZGEO] = GEOPACK_MAG2GEO(XMAG,YMAG,ZMAG)
global GEOPACK1;
XGEO=XMAG*GEOPACK1.CTCL-YMAG*GEOPACK1.SL0+ZMAG*GEOPACK1.STCL;
YGEO=XMAG*GEOPACK1.CTSL+YMAG*GEOPACK1.CL0+ZMAG*GEOPACK1.STSL;
ZGEO=ZMAG*GEOPACK1.CT0-XMAG*GEOPACK1.ST0;
% end of function GEOMAG
% c
% c=========================================================================================
% c

