function [A,B,C] = GEOPACK_MAGSM (X,Y,Z,J)
% function [A,B,C] = GEOPACK_MAGSM (X,Y,Z,J)
%      SUBROUTINE MAGSM (XMAG,YMAG,ZMAG,XSM,YSM,ZSM,J)
% C
% C  CONVERTS DIPOLE (MAG) TO SOLAR MAGNETIC (SM) COORDINATES OR VICA VERSA
% C
% C                    J>0              J<0
% C----INPUT: J,XMAG,YMAG,ZMAG     J,XSM,YSM,ZSM
% C----OUTPUT:    XSM,YSM,ZSM       XMAG,YMAG,ZMAG
% C
% C  ATTENTION:  SUBROUTINE  RECALC  MUST BE INVOKED BEFORE MAGSM IN TWO CASES:
% C     /A/  BEFORE THE FIRST TRANSFORMATION OF COORDINATES
% C     /B/  IF THE VALUES OF IYEAR,IDAY,IHOUR,MIN,ISEC HAVE BEEN CHANGED
% C
% C     LAST MODIFICATION:  MARCH 31, 2003
% C
% C     AUTHOR:  N. A. TSYGANENKO
% C

%      COMMON /GEOPACK1/ A(8),SFI,CFI,B(7),AB(10),BA(8)
% C
if J<0,
    [A,B,C] = GEOPACK_SM2MAG(X,Y,Z);
else
    [A,B,C] = GEOPACK_MAG2SM(X,Y,Z);
end

function [XSM,YSM,ZSM] = GEOPACK_MAG2SM(XMAG,YMAG,ZMAG);
global GEOPACK1;
XSM=XMAG*GEOPACK1.CFI-YMAG*GEOPACK1.SFI;
YSM=XMAG*GEOPACK1.SFI+YMAG*GEOPACK1.CFI;
ZSM=ZMAG;
function [XMAG,YMAG,ZMAG] = GEOPACK_SM2MAG(XSM,YSM,ZSM);
global GEOPACK1;
XMAG=XSM*GEOPACK1.CFI+YSM*GEOPACK1.SFI;
YMAG=YSM*GEOPACK1.CFI-XSM*GEOPACK1.SFI;
ZMAG=ZSM;

% end of function MAG2SM
% C
% C=======================================================================================
% C


