function [A,B,C] = GEOPACK_SMGSM (X,Y,Z,J)
% function [A,B,C] = GEOPACK_SMGSM (X,Y,Z,J)
%       SUBROUTINE SMGSM (XSM,YSM,ZSM,XGSM,YGSM,ZGSM,J)
% C
% C CONVERTS SOLAR MAGNETIC (SM) TO GEOCENTRIC SOLAR MAGNETOSPHERIC
% C   (GSM) COORDINATES OR VICA VERSA.
% C                  J>0                 J<0
% C-----INPUT: J,XSM,YSM,ZSM        J,XGSM,YGSM,ZGSM
% C----OUTPUT:  XGSM,YGSM,ZGSM       XSM,YSM,ZSM
% C
% C  ATTENTION:  SUBROUTINE RECALC  MUST BE INVOKED BEFORE SMGSM IN TWO CASES:
% C     /A/  BEFORE THE FIRST TRANSFORMATION OF COORDINATES
% C     /B/  IF THE VALUES OF IYEAR,IDAY,IHOUR,MIN,ISEC HAVE BEEN CHANGED
% C
% C     LAST MODIFICATION:  MARCH 31, 2003
% C
% C     AUTHOR:  N. A. TSYGANENKO
% C

%      COMMON /GEOPACK1/ A(10),SPS,CPS,B(15),AB(8)
if J<0,
    [A,B,C] = GEOPACK_GSM2SM(X,Y,Z);
else
    [A,B,C] = GEOPACK_SM2GSM(X,Y,Z);
end

function [XGSM,YGSM,ZGSM] = GEOPACK_SM2GSM(XSM,YSM,ZSM);
global GEOPACK1;
XGSM=XSM*GEOPACK1.CPS+ZSM*GEOPACK1.SPS;
YGSM=YSM;
ZGSM=ZSM*GEOPACK1.CPS-XSM*GEOPACK1.SPS;

function [XSM,YSM,ZSM] = GEOPACK_GSM2SM(XGSM,YGSM,ZGSM);
global GEOPACK1;
XSM=XGSM*GEOPACK1.CPS-ZGSM*GEOPACK1.SPS;
YSM=YGSM;
ZSM=XGSM*GEOPACK1.SPS+ZGSM*GEOPACK1.CPS;

%end of function SMGSM
% C
% C==========================================================================================
% C


