function B = compute_Earth_magnetic_field_intensity(r,lambda)
% B = COMPUTE_EARTH_MAGNETIC_FIELD_INTENSITY(R,L)
%   Uses a simple dipole model to compute the magnetic field intensity at a
%   given radius and magnetic latitute. It uses a simple dipole model to
%   compute the magnetic field intensity.
%
% Input:
%   r           Radius from the center of the Earth [m]
%   lambda      Magnetic latitute [rad]
%
% Output:
%   B(r,lambda) Magnetic field intensity [T]


R_Earth = 6378137;                  % Radius of Earth [m]

%   mu_0 = 4*pi*10^(-7)             Permeability of free space [Wb/A/m]
%   m                               Dipole moment [C*m]
%   B_0  = mu_0*m/(4*pi*R_Earth^3)  Magnetic field intensity on the Earth's
%                                   surface at the magnetic equator [T]
B_0 = 0.00003061;

%   B = mu_0*m/(4*pi*R_Earth^3)*sqrt(1 + 3*cos(lambda).^2)
B = B_0*sqrt(1 + 3*cos(pi/2 - lambda).^2)./(r/R_Earth).^3;


%B = B_0.*sqrt(1 + 3*cos(pi/2 - L).^2)./(R/R_Earth).^3;
%B = B_0*sqrt(1 + 3*cos(lambda).^2)./(r/R_Earth).^3;
%B = B_0*(R'./R_Earth).^(-3)*(1 + sin(L).^2).^(1/2);