clear;
close all;

%R = 6800000:200000:26600000;
%L = -pi:pi/100:pi;
%[X,Y] = meshgrid(7000000:200000:25000000,-25000000:200000:25000000);
%[L,R] = cart2pol(X,Y);
[lambda,r] = meshgrid((-90:2:90)*pi/180,6800000:100000:70000000);
theta = pi/2 - lambda;

B = compute_Earth_magnetic_field_intensity(r,lambda);

[x,y] = pol2cart(lambda,r);
contour(x,y,B,10);

%X = R(1).*cos(L);
%Y = R(1).*sin(L);
%Z = B(1,:);
%if (length(R) > 1)
%    for i = 2:length(R)
%        X = [X R(i).*cos(L)];
%        Y = [Y R(i).*sin(L)];
%        Z = [Z B(i,:)];
%    end
%end
