clear;
close all;
global RADIATION_DB;
load_AP8AE8_data;

year  = 2003;
month = 10;
day   = 15;
hour  = 18;
minute   = 0;
second   = 0;

[phi,radius] = meshgrid((0:2:360)*pi/180,(1:0.1:10).*6378137);
theta = -71*ones(size(phi));

[M,N] = size(phi);
proton_energy = 1;
electron_energy = 1;
for i = 1:M
    for j = 1:N
[proton_flux(i,j),electron_flux(i,j)] = compute_irradiation_flux...
                                            (year,month,day,hour,minute,second,...
                                             radius(i,j),theta(i,j),phi(i,j),...
                                             proton_energy,electron_energy,0);
                                     end
                                 end
                                 
[x,y,z] = sph2cart(theta,pi/2 - phi,radius/6378137);
mesh(x,z,proton_flux);
xlabel('x-axis [Earth Radius]');
ylabel('z-axis [Earth Radius]');
zlabel('1 MeV Proton Irradiation [p/cm^2-s]');
figure;
mesh(x,z,electron_flux);
xlabel('x-axis [Earth Radius]');
ylabel('z-axis [Earth Radius]');
zlabel('1 MeV Electron Irradiation [p/cm^2-s]');