function [latitude_new,longitude_new] = geographic2geomagnetic(latitude,longitude)

%south_pole_longitude = 288.59*pi/180;   % Longitude of Earth's magnetic south pole
%south_pole_latitude  = 79.30*pi/180;    % Latitude of Earth's magnetic south pole

% http://medialab.di.unipi.it/web/IUM/Waterloo/node140.html

north_pole_longitude = 

rotation_latitude  = 90 * pi/180;
rotation_longitude = 0 * pi/180;
rotation_angle     = 45 * pi/180;
rotation_vector    = [cos(rotation_latitude)*cos(rotation_longitude);
                      cos(rotation_latitude)*sin(rotation_longitude);
                      sin(rotation_latitude)]
q_r     = [sin(rotation_angle/2)*rotation_vector; cos(rotation_angle/2)]
q_r_inv = [-q_r(1:3); q_r(4)];

x_geographic = cos(latitude)*cos(longitude);
y_geographic = cos(latitude)*sin(longitude);
z_geographic = sin(latitude);
q_p          = [x_geographic; y_geographic; z_geographic; 0]

q = quaternion_product(quaternion_product(q_r,q_p),q_r_inv)
%q = quaternion_product(q_r,quaternion_product(q_p,q_r_inv))

latitude_new  = asin(q(3));
longitude_new = angle(q(1)/cos(latitude_new)*i + q(2)/cos(latitude_new)*i);

function q = quaternion_product(q_1,q_2)
q = [q_1(4)*q_2(1:3) + q_2(4)*q_1(1:3) + cross(q_1(1:3),q_2(1:3));
     q_1(4)*q_2(4) - q_1(1:3)'*q_2(1:3)];

