function load_AP8AE8_data()
% LOAD_AP8AE8_DATA() loads AP8MAX, AP8MIN, AE8MAX, and AE8MIN data. 
%       .type                           Model map type
%       .flux_log_increments_per_decade Increments per decadeof logarithmic flux
%
%       .epoch                          Epoch of model
%       .energy_scale_factor            Scale factor for energy = E(map)/(E/MeV)
%   		   			                = 6400 (AE-8), 100 (AP-8)
%       .L_scale_factor                 Scale factor for L
%                                       = 2100 (AE-8), 2048 (AP-8)
%       .B_B0_scale_factor              scale factor for B/B0
%                                       = 1024 (AE-8), 2048 (AP-8)
%       .flux_log_scale_factor          Scale factor for logarithm of fluxes
%                                       = 1024 (AE,AP-8)
%       .number_of_elements             Number of elements in map
%                                       = 13548 (AE8MAX), 13168 (AE8MIN),
%                                         6509 (AP8MAX), 6688 (AP8MIN)
%       .map                            Data

global RADIATION_DB;
RADIATION_DB = struct('AP8MAX',[],'AP8MIN',[],'AE8MAX',[],'AE8MIN',[]);
file = {'ap8max.asc' 'ap8min.asc' 'ae8max.asc' 'ae8min.asc'};
data = {'AP8MAX' 'AP8MIN' 'AE8MAX' 'AE8MIN'};

for i = 1:length(data)
     x = textread(file{4},'%6n','delimiter',' ');
    RADIATION_DB = setfield(RADIATION_DB,data{i},struct('type',x(1),...
                                         'flux_log_increments_per_decade',x(2),...
                                         'epoch',x(3),...
                                         'energy_scale_factor',x(4),...
                                         'L_scale_factor',x(5),...
                                         'B_B0_scale_factor',x(6),...
                                         'flux_log_scale_factor',x(7),...
                                         'number_of_elements',x(8),...
                                         'map',x(9:length(x))));
end
                                  
