function [proton_flux,electron_flux] = radbelt(year,month,day,hour,minute,second,...
                                               radius,theta,phi,...
                                               proton_energy,electron_energy,solar_max)
% Test

R_Earth = 6378137;              % Earth radius [m]

% Decide which data to use.
if (solar_max)
    % If solar max, use AP8MAX and AE8MAX data. 
    AP_data = 'AP8MAX';
    AE_data = 'AE8MAX';
else
    % Otherwise, use AP8MIN and AE8MIN data.
    AP_data = 'AP8MIN';
    AE_data = 'AE8MIN';
end

for i = 1:length(year)
    % Initialize for magnetic field intensity calculation. 
    GEOPACK_RECALC(year,datenum(year(i),month(i),day(i)) - datenum(year(i),1,1) + 1,hour(i),min(i),sec(i));
    % Magnetic field vector at (r,theta,phi) in Geocentric Geographic
    % spherical coordinate [nT].
    [B_r,B_theta,B_phi] = GEOPACK_IGRF_GEO((r(i)/R_Earth),theta,phi);
    % Magnetic field intensity [nT].
    BetaValueF = sqrt(B_r^2 + B_theta^2 + B_phi^2);
    
    % Compute L value
    bottomF = 4 - (BetaValueF^2*(r(i)/R_Earth)^6/(3.06e4*3.06e4));
    Lvalue  = 3*(r(i)/R_Earth)/bottomF;

    % From page 8 of the AP-8 Trapped Proton Documnent;
    % also easily derivable from dipole approximation
    B_B0 = BetaValueF*Lvalue^3/3.06e4;

    % Compute proton irradiation flux [p/cm^2/s]
    proton_flux(i,:) = 10.^trara1(L,B_B0,proton_energy,AP_data);
    % Compute electron irradiation flux [p/cm^2/s]
    electron_flux(i,:) = 10.^trara1(L,B_B0,electron_energy,AP_data);
end
