function flux = trara1(L,B_B0,E,map_type)
% FLUX = TRARA1(L,B_B0,ENERGY,MAP_TYPE) computes proton and electron flux.
%
% Input
%   L           L-value of the magnetic shell currently in 
%   B_B0        Magnetic field intensity normallized by the
%               magnetic field intensity at the magnetic
%               equitorial on the surface of Earth
%   E           Energy [MeV]
%   map_type    Trapped radiation map type [AP8MAX,AP8MIN,AE8MAX,AE8MIN]
%
% Output
%   flux        Decadic logarithm of integral fluxe [p/cm^2/s]
%
%
% This section uses code translated from trmfun.for code written by:
%       Bieter Bilitza
%       TRMFUN.FOR
%       Trapped Radiation Models Program RADBELT
%       March 25, 1988
%       NASA Goddard Space Flight Center, code 633

global RADIATION_DB;
if map_type == 'AP8MAX'
    map_description = RADIATION_DB.AP8MAX;
    MAP             = RADIATION_DB.AP8MAX.map;
elseif map_type == 'AP8MIN'
    map_description = RADIATION_DB.AP8MIN;
    MAP             = RADIATION_DB.AP8MIN.map;
elseif map_type == 'AE8MAX'
    map_description = RADIATION_DB.AE8MAX;
    MAP             = RADIATION_DB.AE8MAX.map;
elseif map_type == 'AE8MIN'
    map_description = RADIATION_DB.AE8MIN;
    MAP             = RADIATION_DB.AE8MIN.map;
end

F1 = 1.001;
F2 = 1.002;  

FISTEP = map_description.flux_log_scale_factor/map_description.flux_log_increments_per_decade;
ESCALE = map_description.energy_scale_factor;
FSCALE = map_description.flux_log_scale_factor;
XNL = min(15.6,abs(L));
NL = XNL*map_description.L_scale_factor;
if B_B0 < 1
    B_B0 = 1;
end
NB = (B_B0 - 1)*map_description.B_B0_scale_factor;

% I2 IS THE NUMBER OF ELEMENTS IN THE FLUX MAP FOR THE FIRST ENERGY.
% I3 IS THE INDEX OF THE LAST ELEMENT OF THE SECOND ENERGY MAP.
% L3 IS THE LENGTH OF THE MAP FOR THE THIRD ENERGY.
% E1 IS THE ENERGY OF THE FIRST ENERGY MAP (UNSCALED)
% E2 IS THE ENERGY OF THE SECOND ENERGY MAP (UNSCALED)
I1 = 0;
I1 = 0;
I2 = MAP(1);
I3 = I2 + MAP(I2+1);
L3 = MAP(I3+1);
E1 = MAP(I1+2)/ESCALE;
E2 = MAP(I2+2)/ESCALE;

% S0, S1, S2 ARE LOGICAL VARIABLES WHICH INDICATE WHETHER THE FLUX FOR
% A PARTICULAR E, B, L POINT HAS ALREADY BEEN FOUND IN A PREVIOUS CALL
% TO FUNCTION TRARA2. IF NOT, S.. =.TRUE.
S1 = 1;
S2 = 1;

% ENERGY LOOP
for IE = 1:size(E)
    % FOR EACH ENERGY E(I) FIND THE SUCCESSIVE ENERGIES E0,E1,E2 IN 
    % MODEL MAP, WHICH OBEY  E0 < E1 < E(I) < E2 . 
    while (~((E(IE) <= E2) | (L3==0)))
        I0 = I1;
      	I1 = I2;
        I2 = I3;
      	I3 = I3 + L3;
        L3 = MAP(I3+1);
      	E0 = E1;
      	E1 = E2;
        E2 = MAP(I2+2)/ESCALE;
      	S0 = S1;
      	S1 = S2;
        S2 = 1;
      	F0 = F1;
      	F1 = F2;
    end

    % CALL TRARA2 TO INTERPOLATE THE FLUX-MAPS FOR E1,E2 IN L-B/B0-
    % SPACE TO FIND FLUXES F1,F2 [IF THEY HAVE NOT ALREADY BEEN 
    % CALCULATED FOR A PREVIOUS E(I)].
    if (S1)
        F1 = trara2(NL,NB,map_type,I1+3-1)/FSCALE;
    end
    if (S2)
        F2 = trara2(NL,NB,map_type,I2+3-1)/FSCALE;
    end
    S1 = 0;
    S2 = 0;    
    
    % FINALLY, INTERPOLATE IN ENERGY.
    F(IE) = F1 + (F2 - F1)*(E(IE) - E1)/(E2 - E1);
    if ~((F2 > 0) | (I1 == 0))
        % --------- SPECIAL INTERPOLATION ---------------------------------
        % IF THE FLUX FOR THE SECOND ENERGY CANNOT BE FOUND (I.E. F2=0.0),
        % AND THE ZEROTH ENERGY MAP HAS BEEN DEFINED (I.E. I1 NOT EQUAL 0), 
        % THEN INTERPOLATE USING THE FLUX MAPS FOR THE ZEROTH AND FIRST 
        % ENERGY AND CHOOSE THE MINIMUM OF THIS INTERPOLATIONS AND THE
        % INTERPOLATION THAT WAS DONE WITH F2=0. 
        if (S0)
            F0 = trara2(NL,NB,map_type,I0+3-1)/FSCALE;
        end
        S0 = 0;  
        F(IE) = min(F(IE),F0+(F1-F0)*(E(IE)-E0)/(E1-E0));
    end
    F(IE) = max(F(IE),0);
end
flux = F;

function f = trara2(IL,IB,map_type,offset)
%*****************************************************************
%***  TRARA2 INTERPOLATES LINEARLY IN L-B/B0-MAP TO OBTAIN     ***
%***  THE LOGARITHM OF INTEGRAL FLUX AT GIVEN L AND B/B0.      ***
%***    INPUT: MAP[] IS SUB-MAP (FOR SPECIFIC ENERGY) OF       ***
%***                   TRAPPED RADIATION MODEL MAP             ***
%***           IL      SCALED L-VALUE                          ***
%***           IB      SCALED B/B0-1                           ***
%***   OUTPUT: TRARA2  SCALED LOGARITHM OF PARTICLE FLUX       ***
%*****************************************************************
%***  SEE MAIN PROGRAM 'MODEL' FOR EXPLANATION OF MAP FORMAT   ***
%***  SCALING FACTORS.                                         ***
%***  THE STEPSIZE FOR THE PARAMETERIZATION OF THE LOGARITHM   ***
%***  OF FLUX IS OBTAINED FROM 'COMMON/TRA2/'.                 ***
%*****************************************************************/
% /*     FUNCTION TRARA2(int MAP,IL,IB) */

global RADIATION_DB;
if map_type == 'AP8MAX'
    map_description = RADIATION_DB.AP8MAX;
    MAP             = RADIATION_DB.AP8MAX.map;
elseif map_type == 'AP8MIN'
    map_description = RADIATION_DB.AP8MIN;
    MAP             = RADIATION_DB.AP8MIN.map;
elseif map_type == 'AE8MAX'
    map_description = RADIATION_DB.AE8MAX;
    MAP             = RADIATION_DB.AE8MAX.map;
elseif map_type == 'AE8MIN'
    map_description = RADIATION_DB.AE8MIN;
    MAP             = RADIATION_DB.AE8MIN.map;
end
FISTEP = map_description.flux_log_scale_factor/map_description.flux_log_increments_per_decade;
I2     = 0;
ITIME  = 0;
FNB    = IB;
FNL    = IL; 
% FIND CONSECUTIVE SUB-SUB-MAPS FOR SCALED L-VALUES LS1,LS2, 
% WITH IL LESS OR EQUAL LS2.  L1,L2 ARE LENGTHS OF SUB-SUB-MAPS. 
% I1,I2 ARE INDECES OF FIRST ELEMENTS MINUS 1.
L2 = MAP(offset+I2+1);
while (MAP(offset+I2+2) <= IL)
    I1 = I2;
    L1 = L2;
    I2 = I2 + L2;
    L2 = MAP(offset+I2+1);
end

% IF SUB-SUB-MAPS ARE EMPTY, I. E. LENGTH LESS 4, THAN TRARA2=0
if ((L1 < 4) & (L2 < 4))
    f = 0;
    return;
end

% IF FLOG2 LESS FLOG1, THAN LS2 FIRST MAP AND LS1 SECOND MAP
if (MAP(offset+I2+3) <= MAP(offset+I1+3))
    KT = I1;
    I1 = I2;
    I2 = KT;
    KT = L1;
    L1 = L2;
    L2 = KT;
end

goto_position = 0;

% DETERMINE INTERPOLATE IN SCALED L-VALUE
FLL1 = MAP(offset+I1+2);
FLL2 = MAP(offset+I2+2);
DFL = (FNL - FLL1)/(FLL2 - FLL1);
FLOG1 = MAP(offset+I1+3);
FLOG2 = MAP(offset+I2+3);
FKB1 = 0;
FKB2 = 0;
if (L1 < 4)
    goto_position = 32;
end

if (goto_position == 0)
    % B/B0 LOOP
    for J2 = 4:L2
        FINCR2 = MAP(offset+I2+J2);
        if ((FKB2 + FINCR2) > FNB)
            goto_position = 23;
            break;
        end
        FKB2 = FKB2 + FINCR2;
        FLOG2 = FLOG2 - FISTEP;
    end
end

if (goto_position == 0)
    ITIME = ITIME + 1;

    KT = I1;
    I1 = I2;
    I2 = KT;
    KT = L1;
    L1 = L2;
    L2 = KT;

    % DETERMINE INTERPOLATE IN SCALED L-VALUE
    FLL1 = MAP(offset+I1+2);
    FLL2 = MAP(offset+I2+2);
    DFL = (FNL - FLL1)/(FLL2 - FLL1);
    FLOG1 = MAP(offset+I1+3);
    FLOG2 = MAP(offset+I2+3);
    FKB1 = 0;
    FKB2 = 0;
    if (L1 < 4)
        goto_position = 32;
    end
    
    if (goto_position == 0)
        % B/B0 LOOP
        for J2 = 4:L2
            FINCR2 = MAP(I2+J2);
            if ((FKB2 + FINCR2) > FNB)
                goto_position = 23;
                break;
            end
            FKB2 = FKB2 + FINCR2;
            FLOG2 = FLOG2 - FISTEP;
        end
        if (goto_position == 0)
            ITIME = ITIME + 1;
            f = 0;
            return;
        end
    end
end

if (goto_position == 0 | goto_position == 23)
    goto_position = 0;
    if (ITIME == 1)
        goto_position = 30;
    elseif (J2 == 4)
        goto_position = 28;
    else
        SL2 = FLOG2/FKB2;
        for J1 = 4:L1
            FINCR1 = MAP(offset+I1+J1);
      	    FKB1=FKB1+FINCR1;
            FLOG1=FLOG1-FISTEP;
            FKBJ1=((FLOG1/FISTEP)*FINCR1+FKB1)/((FINCR1/FISTEP)*SL2 + 1);
            if (FKBJ1 <= FKB1)
                goto_position = 31;
                break;
            end
        end
    end
end

if (goto_position == 0 & (FKBJ1 <= FKB2))
    f = 0;
    return;
end

if ((goto_position == 0 | goto_position == 31) & (FKBJ1 <= FKB2))
    goto_position = 29;
end;

if (goto_position == 0)
    FKB1 = 0;
end

if (goto_position == 0 | goto_position == 30)
    goto_position == 0;
    FKB2 = 0;
end

if (goto_position == 0 | goto_position == 32)
    goto_position == 0;
    J2 = 4;                                             
    FINCR2 = MAP(I2+J2);                                                 
    FLOG2 = MAP(I2+3);                                                  
    FLOG1 = MAP(I1+3);
end

if (goto_position == 0 | goto_position == 28)
    goto_position = 0;
    FLOGM = FLOG1 + (FLOG2-FLOG1)*DFL;
    FKBM = 0;
    FKB2 = FKB2 + FINCR2; 
    FLOG2 = FLOG2 - FISTEP; 
    SL2 = FLOG2/FKB2;
    if (L1 < 4)
        goto_position = 35;
    end
    if (goto_position == 0)
        J1 = 4;
        FINCR1 = MAP(I1+J1);                                                
        FKB1 = FKB1 + FINCR1;
        FLOG1 = FLOG1 - FISTEP;
        SL1 = FLOG1/FKB1;
        goto_position = 15;
    end
end

if (goto_position == 0 | goto_position == 29)
    goto_position = 0;
    FKBM = FKBJ1 + (FKB2 - FKBJ1)*DFL;
    FLOGM = FKBM*SL2;
    FLOG2 = FLOG2-FISTEP;
    FKB2 = FKB2+FINCR2;
    SL1 = FLOG1/FKB1;
    SL2 = FLOG2/FKB2;
end

if (goto_position == 35)
    goto_position = 0;
    FINCR1 = 0;
    SL1 = -900000;
    FKBJ1 = ((FLOG1/FISTEP)*FINCR1+FKB1)/((FINCR1/FISTEP)*SL2 + 1);
    FKB = FKBJ1 + (FKB2 - FKBJ1)*DFL;
    FLOG = FKB*SL2;
    if (FKB >= FNB)
        goto_position = 60;
        break;
    end
    FKBM = FKB;
    FLOGM = FLOG;
    if (J2 >= L2)
        f = 0;
        return;
    end
    J2 = J2 + 1;
    FINCR2 = MAP(I2+J2);
    FLOG2 = FLOG2 - FISTEP;
    FKB2 = FKB2 + FINCR2;
    SL2 = FLOG2/FKB2;
    goto_position = 15;
end

if (goto_position == 0 | goto_position == 15)
    goto_position = 0;
    while (1)
        if (SL1 >= SL2)
            FKBJ2 = ((FLOG2/FISTEP)*FINCR2 + FKB2)/((FINCR2/FISTEP)*SL1 + 1);
      	    FKB = FKB1 + (FKBJ2 - FKB1)*DFL;
      	    FLOG = FKB*SL1;
            if (FKB >= FNB)
                goto_position = 60;
                break;
            end
      	    FKBM = FKB;
          	FLOGM = FLOG;
            if (J1 >= L1)
                f = 0;
                return;
            end
          	J1 = J1 + 1;
            FINCR1 = MAP(I1+J1);
          	FLOG1 = FLOG1 - FISTEP;
          	FKB1=FKB1+FINCR1;
          	SL1 = FLOG1/FKB1;
        else
            FKBJ1 = ((FLOG1/FISTEP)*FINCR1+FKB1)/((FINCR1/FISTEP)*SL2 + 1);
            FKB = FKBJ1 + (FKB2 - FKBJ1)*DFL;
            FLOG = FKB*SL2;
            if (FKB >= FNB)
                goto_position = 60;
                break;
            end
            FKBM = FKB;
            FLOGM = FLOG;
            if (J2 >= L2)
                f = 0;
                return;
            end
            J2 = J2 + 1;
            FINCR2 = MAP(I2+J2);
            FLOG2 = FLOG2 - FISTEP;
            FKB2 = FKB2 + FINCR2;
            SL2 = FLOG2/FKB2;
        end
    end
end

if (goto_position == 60)
    goto_position = 0;
    if (FKB < (FKBM + 1e-10))
        f = 0;
        return;
    end
    f = FLOGM + (FLOG - FLOGM)*((FNB - FKBM)/(FKB - FKBM));
    f = max(f,0);
    return;
end

f = 0;