clear all ;

clc;
disp(' ');
disp('-------------------------------');

fname=input('Input file name:','s')

disp(['Loading  ' ,  num2str(fname)]);

d = parsedl2(fname,2)';

disp('Building BW filter at 0.1 ...');
[b,a]= butter(4,.04); 

ifx = 1 ;

disp('Filtering Data...');
d(:,ifx) = filtfilt(b,a,d(:,ifx)) ;

figure(1);clf;hold off;
plot(d(:,ifx));
grid;
title('  Pick zero level (2 points) and loaded level (2 points)');
zoom off;[x,y] = ginput(4) ;zoom on;
vx = mean(d(round(x(3)):round(x(4)),ifx))- ...
	mean(d(round(x(1)):round(x(2)),ifx));

disp(' ');
disp(sprintf('Load causes %5.4f V in x.',vx)) ;
disp('-------------------------------');
disp(' ');
