from athenaCL.libATH import athenaObj
from numpy.random import *
ath = athenaObj.Interpreter()

#Player functions
class TextureNameGenerator():
    def __init__(self):
        self.index = 0
    def nextName(self):
        self.index += 1
        return "texture" + str(self.index)

class PathNameGenerator():
    def __init__(self):
        self.index = 0
    def nextName(self):
        self.index += 1
        return "path" + str(self.index)

textureNameGen = TextureNameGenerator()
pathNameGen = PathNameGenerator()

ath.cmd('emo cn')
ath.cmd('tmo LineGroove')

def playPitchSequencesWithDurations(sequences, durations, volumes, instruments):
    for i in range(len(sequences)):
        playPitchSequenceWithDurations(sequences[i],durations[i],volumes[i],instruments[i])

    ath.cmd("eln")
    ath.cmd("elr")

def playPitchSequenceWithDurations(sequence,durations,volumes,instrument):
    textureName = textureNameGen.nextName()
    pathName = pathNameGen.nextName()
    totalDuration = sum(durations)
    bpm = 60.0
    
    #pitches
    #ath.cmd("pin " + pathName + " " + notesToAthenaCL(sequence))
    ath.cmd("tin " + textureName + " " + str(instrument))
    ath.cmd("tie s1 oc")
    
    #volumes
    ath.cmd("tie a (bg,oc,(" + volumes + "))")
    print "edited v"

    #pitches
    ath.cmd("tie f (bg,oc,("+ notesToAthenaCL(sequence) + "))")
    #ath.cmd("tie x0 (c,800)")
    print "edited f"

    #durations
    durationsPrint = durationsToAthenaCL(durations)
    ath.cmd("tie r loop, " + durationsPrint + ", oc")
    print "edited r"
    ath.cmd("tie b constant," + str(bpm))

    #start and end time
    ath.cmd("tie t 0, " + str(totalDuration))

def volumesToAthenaCL(volumes):
    athenaCL = ""
    for volume in volumes:
        athenaCL = athenaCL + str(volume) + ","
    return athenaCL[0:-1]

def notesToAthenaCL(notes):
    athenaCL = ""
    for note in notes:
        athenaCL = athenaCL + str(note) + ","
    athenaCL = athenaCL[0:-1]
    return athenaCL

def durationsToAthenaCL(durations):
    athenaCL = "("
    for duration in durations:
        athenaCL = athenaCL + "(" + str(64) + "," + str(duration * 64) + ",1),"
    athenaCL = athenaCL[0:len(athenaCL) - 1] + ")"
    return athenaCL

#Clarinet
#playPitchSequenceWithDurations(["C5"],[20],21)
#Piano
#playPitchSequenceWithDurations(["C5"],[20],70)
#hi hat
#playPitchSequenceWithDurations(['E5','D5','C5'],[(x/500) + 0.25 for x in range(500)],80)

#ath.cmd('eln')
#ath.cmd('elr')
#ath.cmd('elh')

# +-24 values
