package words;

import java.awt.BorderLayout;
import java.awt.Container;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

/**
 * WordFinder is an interface for searching a word list.
 * When the user types any part of a word, the interface
 * displays all the words that match.
 */
public class WordFinder extends JFrame {

    private static final long serialVersionUID = 1L;
    
    private final WordList words = new WordList();
    
    private final JTextField find;
    
    /**
     * Make a WordFinder window.
     */
    public WordFinder() {
        super("Word Finder");
        
        // call System.exit() when user closes the window
        setDefaultCloseOperation(EXIT_ON_CLOSE);
        
        Container cp = this.getContentPane();
        /*
         * Task 2: set the layout manager of the content pane to a TableLayout.
         */
        
        cp.add(new JLabel("Find: "), BorderLayout.WEST);
        
        cp.add(find = new JTextField(20), BorderLayout.CENTER);
        /*
         * Task 1: add an action listener to `find' that outputs matching words
         *         to the console
         */
        
        /*
         * Task 3: add a JList inside a JScrollPane that shows matching words
         */
        
        /*
         * Task 4: add a JLabel that shows the number of matching words
         */
        
        /*
         * Task 5: add a Search button
         */
        
        /*
         * Task 6: add a File menu with Open... and Exit options
         */
        
        this.pack();
        
        try {
            InputStream in = new FileInputStream("words");
            loadWords(in);
        } catch (IOException ioe) { }
    }
    
    private void loadWords(InputStream in) throws IOException {
        words.load(in);
        // ...
    }
    
    /**
     * Main method.  Makes and displays a WordFinder window.
     * @param args Command-line arguments.  Ignored.
     */
    public static void main(String[] args) {
        // In general, Swing objects should only be accessed from
        // the event-handling thread -- not from the main thread
        // or other threads you create yourself.  SwingUtilities.invokeLater()
        // is a standard idiom for switching to the event-handling thread.
        SwingUtilities.invokeLater(new Runnable() {
            public void run () {
                // Make and display the WordFinder window.
                new WordFinder().setVisible(true);
            }
        });
    }    
}
