package friendly;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

/**
 * The friendly ear program chats with the user until the user types "bye", then
 * terminates.
 */
public class Main {

	public static void main(String[] args) {

		// Create a buffered reader. Buffered readers let you
		// read from a stream a line at a time.
		BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));

		// Start by printint out a greeting.
		System.out.println("Hello, my friend! How are you today?");

		try {
			// Read the first line.
			String line = reader.readLine();

			while (line != null) { // line==null means the end of the stream
									// was reached.

				// If user typed "bye", exit the loop.
				// Use `toLowerCase' and `startsWith' to allow variations like
				// `BYE',`Bye', `bye!', etc.
				if (line.toLowerCase().startsWith("bye")) {
					System.out.println("Well, bye then.");
					break;
				}

				if (line.endsWith("?")) {
					// User asked a question.
					System.out.println("Interesting question.");
				} else {
					System.out.println("I see. Why is that?");
				}

				// Read next line.
				line = reader.readLine();
			}

		} catch (IOException e) {
			System.out.println("I/O error: " + e.getMessage());
			System.exit(1);
		}
	}
}
