package friendly.multi;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;

/**
 * Handles one user's Friendly session.
 */
public class FriendlyClientHandler implements Runnable {
    private BufferedReader reader;
    private PrintWriter writer;
    
    public FriendlyClientHandler(BufferedReader reader, PrintWriter writer) {
        this.reader = reader;
        this.writer = writer;
    }
    
	public void run() {
        System.out.println("Connection opened");
        try {
            // Read the first line.
            String line = reader.readLine();
    
            while (line != null) { // line==null means the end of the stream
                                    // was reached.
				writer.println("you said: " + line);
				writer.flush();
	            line = reader.readLine();
            }
            reader.close();
            writer.close();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		System.out.println("Connection closed");
	}
}