package collab;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

/**
 * Main runner for SVN collaboration exercise.
 * 
 * Do not edit this class.
 * 
 * @author maxg
 */
public class Main {
    
    public static void main(String[] args) throws URISyntaxException {
        List<Class<?>> classes = new ArrayList<Class<?>>();
        
        String pkg = "collab";
        
        // find all the classes in our package; this enumeration trick only works
        // by looking at the filesystem
        URL url = ClassLoader.getSystemResource(pkg);
        URI uri = url.toURI();
        File directory = new File(uri);
        String[] files = directory.list();
        if (files == null) {
            throw new RuntimeException("No files found in directory " + directory);
        }

        for (String file : files) {
            if (file.endsWith(".class")) {
                try {
                    classes.add(Class.forName(pkg + "." + file.replaceFirst("\\.class$", "")));
                } catch (ClassNotFoundException cnfe) {
                    System.err.println("No class for apparent class file: " + file);
                }
            }
        }
        
        // instantiate each class and print its String representation
        for (Class<?> klass : classes) {
            try {
                String says = klass.getName() + " says: " + klass.newInstance().toString();
                System.out.println(says);
            } catch (IllegalAccessException e) {
                System.out.println(klass.getName() + " is not accessible");
            } catch (InstantiationException e) {
                System.out.println(klass.getName() + " cannot be instantiated");
            }
        }
    }
    
    @Override public String toString() {
        return "Here's the Main class.";
    }
}
