import unittest
from johnson    import johnson

tests = (
    (
        (
            4,
            ((0, 1, -1), (0, 2, -2), (1, 3, -5), (2, 1, -3), (2, 3, -4)),
        ),
        ((0, -5, -2, -10), (99999, 0, 99999, -5), (99999, -3, 0, -8), (99999, 99999, 99999, 0)),
    ),
    (
        (
            4,
            ((0, 1, -6), (0, 2, 3), (1, 3, 1), (2, 1, -5), (3, 2, 2)),
        ),
        None,
    ),
    (
        (
            5,
            ((0, 2, 21), (0, 3, 18), (0, 4, 18), (2, 0, 22), (2, 3, 17), (3, 0, 6), (3, 2, 18), (4, 0, 23), (4, 1, 7), (4, 2, 24), (4, 3, -4)),
        ),
        ((0, 25, 21, 14, 18), (99999, 0, 99999, 99999, 99999), (22, 47, 0, 17, 40), (6, 31, 18, 0, 24), (2, 7, 14, -4, 0)),
    ),
    (
        (
            5,
            ((0, 1, 10), (0, 2, 17), (0, 4, 4), (1, 0, -2), (1, 2, 14), (1, 3, 8), (1, 4, 8), (2, 0, 19), (2, 1, 21), (3, 0, -5), (3, 1, 0), (3, 2, 23), (3, 4, 0), (4, 1, 7), (4, 2, -8), (4, 3, 24)),
        ),
        ((0, 10, -4, 18, 4), (-2, 0, -6, 8, 2), (19, 21, 0, 29, 23), (-5, 0, -9, 0, -1), (5, 7, -8, 15, 0)),
    ),
    (
        (
            10,
            ((0, 5, 20), (0, 9, 15), (1, 3, 30), (1, 5, 7), (1, 7, 97), (2, 6, 56), (2, 7, 28), (3, 9, -1), (4, 9, 60), (5, 4, 41), (6, 0, 18), (6, 2, -7), (6, 5, 79), (7, 1, 89), (7, 5, 86), (7, 8, 80), (8, 0, -1), (8, 2, 26), (8, 7, 30), (9, 2, 81)),
        ),
        ((0, 213, 96, 243, 61, 20, 152, 124, 204, 15), (176, 0, 110, 30, 48, 7, 166, 97, 177, 29), (74, 117, 0, 147, 135, 94, 56, 28, 108, 89), (154, 197, 80, 0, 215, 174, 136, 108, 188, -1), (215, 258, 141, 288, 0, 235, 197, 169, 249, 60), (256, 299, 182, 329, 41, 0, 238, 210, 290, 101), (18, 110, -7, 140, 79, 38, 0, 21, 101, 33), (79, 89, 106, 119, 127, 86, 162, 0, 80, 94), (-1, 119, 26, 149, 60, 19, 82, 30, 0, 14), (155, 198, 81, 228, 216, 175, 137, 109, 189, 0)),
    ),
)

def check(test):
    (n, S), staff_sol = test
    student_sol = johnson(n, S)
    if (student_sol is None) or (staff_sol is None):
        return student_sol == staff_sol
    for i in range(n):
        for j in range(n):
            if student_sol[i][j] != staff_sol[i][j]:
                return False
    return True

class TestCases(unittest.TestCase):
    def test_01(self): self.assertTrue(check(tests[ 0]))
    def test_02(self): self.assertTrue(check(tests[ 1]))
    def test_03(self): self.assertTrue(check(tests[ 2]))
    def test_04(self): self.assertTrue(check(tests[ 3]))
    def test_05(self): self.assertTrue(check(tests[ 4]))

if __name__ == '__main__':
   res = unittest.main(verbosity = 3, exit = False)
