function varargout = branching(varargin)
% BRANCHING M-file for branching.fig
%      BRANCHING, by itself, creates a new BRANCHING or raises the existing
%      singleton*.
%
%      H = BRANCHING returns the handle to a new BRANCHING or the handle to
%      the existing singleton*.
%
%      BRANCHING('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in BRANCHING.M with the given input arguments.
%
%      BRANCHING('Property','Value',...) creates a new BRANCHING or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before branching_OpeningFunction gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to branching_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help branching

% Last Modified by GUIDE v2.5 02-Apr-2006 04:37:52

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @branching_OpeningFcn, ...
                   'gui_OutputFcn',  @branching_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin & isstr(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before branching is made visible.
function branching_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to branching (see VARARGIN)

% Choose default command line output for branching
handles.output = hObject;

fig = gcf;
set(fig,'Name','Branching Process');

% Axis settings.
axis([0 1 0 1]);
set(handles.axes2,'XTickLabel',[])
set(handles.axes2,'YTickLabel',[])
box on;


% Update handles structure
guidata(hObject, handles);

% UIWAIT makes branching wait for user response (see UIRESUME)
% uiwait(handles.figure1);


% --- Outputs from this function are returned to the command line.
function varargout = branching_OutputFcn(hObject, eventdata, handles)
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;


% --- Executes during object creation, after setting all properties.
function edit1_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function edit1_Callback(hObject, eventdata, handles)
% hObject    handle to edit1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit1 as text
%        str2double(get(hObject,'String')) returns contents of edit1 as a double


% --- Executes on button press in pushbutton1.
function pushbutton1_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

set(handles.edit1,'Enable','off');
set(handles.pushbutton1,'Enable','off');

% Parameteres.
p=str2num(get(handles.edit1,'String'));
if p==0;
    set(handles.edit1,'String','0.01');
    p=0.01;
end;
% Spread of children around parents (larger=narrower).
snr=25;
% Initialization.
Z=1;
px=[1/2];
py=[1/2];
h=plot(px,py,'o');
set(h,'LineWidth',3);
axis([0 1 0 1]);
set(handles.axes2,'XTickLabel',[])
set(handles.axes2,'YTickLabel',[])
box on;
hold on;
speed=get(handles.slider2,'Value');
pause(0.2-speed);

log1_p = log(1-p);
for t=1:30
    Z_=0;
    px_=[];
    py_=[];
    for i=1:Z
        % Geometric distribution of children.
        R=rand; X=0; while(R>p); X=X+1; R=(R-p)/(1-p);  end; % Method 1
        R=rand; X=ceil(log(1-R)/log1_p)-1;
        % Placement of children.
        if(X>0)
            Z_=Z_+X;
            px_=[px_ awgn(px(i)*ones(1,X),snr)];
            py_=[py_ awgn(py(i)*ones(1,X),snr)];
        end;
    end;
    % Update of plot.
    Z=Z_;
    px=mod(px_,1);
    py=mod(py_,1);
    delete(h);
    if Z>100;
        px=px(randperm(Z));
        py=py(randperm(Z));
        px=px(1:100);
        py=py(1:100);
        Z=100;
    end;

    h=plot(px,py,'o');
    set(h,'LineWidth',3);
    speed=get(handles.slider2,'Value');
    pause(0.2-speed);
     if Z==0; break; end;
end;
% Uninitialization.
hold off;
set(handles.edit1,'Enable','on');
set(handles.pushbutton1,'Enable','on');




% --- Executes during object creation, after setting all properties.
function slider2_CreateFcn(hObject, eventdata, handles)
% hObject    handle to slider2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: slider controls usually have a light gray background, change
%       'usewhitebg' to 0 to use default.  See ISPC and COMPUTER.
usewhitebg = 1;
if usewhitebg
    set(hObject,'BackgroundColor',[.9 .9 .9]);
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end


% --- Executes on slider movement.
function slider2_Callback(hObject, eventdata, handles)
% hObject    handle to slider2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'Value') returns position of slider
%        get(hObject,'Min') and get(hObject,'Max') to determine range of slider


