# we call a procedure from utilities.tcl that automatically defines
# local Tcl vars (i.e., in our environment) with the same names as the
# form variable inputs

# Note that directly underneath the set_the_usual_form_variables
# call, by convention we say what arguments we expect to this page

set_the_usual_form_variables

# full_name, quest, favorite_color

# suppose that we know we're going to return a big block of text,
# instead of using ReturnHeaders and ns_write, we can call the
# AOLserver ns_return API procedure.  This takes the HTTP status code
# (200 is almost always the right thing) and the MIME type

# let's use the Tcl regexp facility to look for
#   ***something*** space(s) ****something***

# note that we are careful to put curly braces around the regexp,
# which doesn't really matter here but would matter if you had
# more REGEXPs in elseif clauses.  All of them would get evaluated
# regardless of the success or failure of the first one; this is
# normally irrelevant but matters in the case of REGEXP because the
# procedure has a side effect on the variables "first_name" and "last_name"
if {[regexp {(.*) +(.*)} $full_name match first_name last_name]} {
    # matched our pattern 
    set our_result "We think we figured out that your first name is \"$first_name\" and your last name is \"$last_name\"."
} else {
    set our_result "We think that you are a tenured LCS professor or a famous singer/actress with only one name; i.e., we couldn't match your name to our regular expression."
}

ns_return 200 text/html "
<html>
<head>
<title>Results of Name Processing</title>
</head>
<body bgcolor=$favorite_color text=white>

<h2>Results of Name Processing</h2>

<hr>

<ul>
<li>Your name:  \"$full_name\"
<li>Our result:  $our_result

</ul>

Good luck with $quest.

<hr>
<address>not-yet-impeached@whitehouse.gov</address>

</body>
</html>
"
