<html>
<head>
<title>Fun with Arithmetic</title>
</head>

<body bgcolor=#ffffff text=#000000>
<h2>Fun with Arithmetic</h2>
<hr>

<ul>

<!-- here's an example of evaluating a Tcl expression and using the result
immediately in the page (the = sign is the key) -->

<li>Two plus two is <%= [expr 2+2] %>

<li>This AOLserver is running version <%= [info tclversion] %> of Tcl.

<% 

# here's an example of escaping to Tcl with <% and executing code
# for its effect on the environment in which we'll evaluate the rest 
# of the page

set aquarium_types_and_costs \
   [list [list "Lake Malawi Cichlid" 5000] \
         [list "Saltwater Community" 7000] \
         [list "Reef" 10000] \
         [list "Planted Freshwater" 6000] \
         [list "Suspended-in-midair Stingray Pond" 45000] \
   ]

%>

<li>The first element of <code><%= $aquarium_types_and_costs %></code> is 
<code><%= [lindex $aquarium_types_and_costs 0] %></code>

<li>Here are some aquarium plans for the new building:
  <ul>

<%

# we will use ns_puts to add to the viewable page from within this 
# page

set total 0 

foreach pair $aquarium_types_and_costs {
    # let's immediately destructure, preserving some 
    # semblance of abstraction
    set aquarium_type [lindex $pair 0]
    set aquarium_cost [lindex $pair 1]
    incr total $aquarium_cost
    ns_puts "<li>$aquarium_type will cost \$$aquarium_cost\n"
}

ns_puts "<p>\n<li>Total:  \$$total"

%>
</ul>

</ul>


<hr>
<a href="http://photo.net/philg/"><address>philg@mit.edu</address></a>
</body>
</html>
