/**
 *  The interface is shared by all ode objects used in the applet
 */

public interface GROrbitODE extends ODE {
   public void setA(double a); //sets a-parameter in ode object
   public double getA(); //returns a-parameter of ode object
   public void setIC(double r, double phi); //sets Initial Conditions for
   //simulation that depend on r, phi, a, Lm, Em, ...
   public double getVm(double r);//returns the value of Effective potential
   //for giver value of r-coordinate. In each ode object these potentials
   //can be (and are) different
   public double getVmAtHorizon();//returns the value of Effective Potential
   //at the horizon, i.e. for r=rHorizon
   public double getR();//returns the actual value of r-coordinate
   public double getPhi();//returns the actual value of phi-coordinate
   public double getTau();//returns the actual value of tau (wristwatch, proper time)
   public double getEm();//returns energy E/m of the orbiter
   public double getLm();//returns angular momentum L/m of the orbiter
   public void setEm(double Em);//sets energy E/m
   public void setLm(double Lm);//sets angular momentum L/m
   public void setInvB(double invB);//sets 1/b parameter
   public double getOrbitParameter();//returns either E/m or 1/b depending
   //on the kind of ode object. The 1/b value is returned only in case of KerrLight ode
   //In other cases E/m is returned.
   public void setOrbitParameter(int j);//Sets orbit parameter (either E/m or 1/b) from
   //the value of pixel j-coordinate on Effective potential plot, after mouse click
   public double getRHorizon();//returns r-coordinate of OUTER horizon, that depends on a-parameter
   public double getRInnerHorizon();//returns r-coordinate of INNER horizon
   public Scale getScale(double rMax);//returns scale object for Effective potential plot
   public void setSign(int s);//sets value of sign on either 1 or -1. This way ode object is
   //told if the orbit has to be outward or inward
   public double getRLocalMin(double rMax);//returns r-coordinate of local
   //minimum in effective potential if it exists. If there is no local minimum
   //it returns 0
   public double getRLocalMax(double rMax);//returns r-coordinate of local
   //maximum in effective potential if it exists. If there is no local maximum
   //it returns 0
   public double rTorPlot(double r);//transforms value of r-coordinate to the value
   //actually used on the orbit plot
   public double rPlotTor(double rPlot);//transforms value of r used on orbit plot
   //to the r-coordinate
   public void initialSetup();//this is called when user moves the slide bars, thus
   //changing a-parameter or Lm-parameter
   //It simply sets initial conditions for simulation, sets scale objects, ...
   public void initialSetupTextual();//this is called when user click OK-button
   //in Textual input window or clicks with mouse to the Effective potential plot
   //to choose energy (or 1/b for light) and r-coordinate
   //It again sets initial conditions for simulation, sets scale objects, ...

}