/**
 * Class for transforming between real world coordinates and pixels
 * (c) Slavomir Tuleja, September 25, 2001
 */

public class Scale {
   private double minX, maxX, minY, maxY, minI, maxI, minJ, maxJ;

   // constructor
   public Scale(double minX, double maxX, double minY, double maxY, double minI, double maxI, double minJ, double maxJ){
      this.minX=minX;
      this.maxX=maxX;
      this.minY=minY;
      this.maxY=maxY;
      this.minI=minI;
      this.maxI=maxI;
      this.minJ=minJ;
      this.maxJ=maxJ;
   }


   public int xToi(double x){
      return Math.round((float)(minI+(x-minX)*(maxI-minI)/(maxX-minX)));
   }


   public int yToj(double y){
      return Math.round((float)(minJ+(maxY-y)*(maxJ-minJ)/(maxY-minY)));
   }


   public double iTox(int i){
      return minX+((double)(i-minI))*(maxX-minX)/((double)(maxI-minI));
   }


   public double jToy(int j){
      return maxY+((double)(j-minJ))*(minY-maxY)/((double)(maxJ-minJ));
   }

}