% computes the derivative of the cosine function numerically

dt = 0.01;              % approximation for Delta t
t = -1:dt:1;            % time vector
m = numel(t);           % number of elements time vector
f = cos(2*pi*t);        % function to be numerically differentiated
dfdt = zeros(m-1,1);    % vector for storing derivatives
for k = 1 : m-1
    dfdt(k,1)=(f(k+1)-f(k))/dt;     % update formula
end
