data = load('distros.mat');     % loads the data into matrix data
data = data.X;
xbar = mean(data,1)             % compute the mean of each column
variance = var(data,[],1)       % compute variance
MAX = max(data,[],1)            % find maximum value
MIN = min(data,[],1)            % find minimum value

xbar2 = mean(data,2)            % compute the mean of each row
variance2 = var(data,[],2)      % compute variance of each row

%% find values that are above a threshold
AboveThr = numel(find(data(:,1)>=xbar(1)))
 
%% compute mode and median of data
Modes = mode(data,1)
Medi = median(data,1)

%% normalize by subtracting the mean value
[r,c] = size(data);
MU = repmat(xbar,r,1);
dataCentered = data - MU;
xbar3 = mean(mean(dataCentered))
