% creates a histogram and curve fit for a distibution of data

data = load('distros.mat');     % load data
X = data.X(:,1);
m = floor(min(X));              % round to lower integer close to minimum
M = ceil(max(X));               % round to larger integer close to maximum
numBins = 20;
bins = m:(M-m)/(numBins-1):M;   % 20 linearly spaced bins
pd=fitdist(X,'Normal');         % fit Normal distribution to data
Ncurve = pdf(pd,bins);          % create a Normal distribution curve
maxHist = max(hist(X, numBins));  % used to scale Ncurve for visualization
scale = max(H)/max(Ncurve);  

% display histogram of data with curve fit superimposed
hist(X, numBins);               
hold on
plot(bins, scale*Ncurve, 'r', 'Linewidth', 2);
