function Z = zscoring(X)
% subtracts the mean from the input data matrix X and divides
% each element by the group standard deviation

[r,c]=size(X);
xbar = mean(X,1);
stdev = std(X,0,1);

M = repmat(xbar,r,1);
S = repmat(sdev,r,1);

Z = (X-M)./S;

end 